#!/usr/bin/env python

# classify_words
# by Javantea
# Oct 1, 2006

from sys import stdin

def classify_words():
	"""
	A brute force method of classifying words.
	This is not fast enough, but you can add you own wclasses using better 
	methods and then brute force the rest.
	"""
	swords = open('words', 'r').read()
	words = swords.split("\n")
	print "Dictionary Length:", len(words)
	print "Usage:"
	print "word is a: [nvadxq] (noun verb adjective adverb exit quit)"
	
	#wclasses = {'n':[], 'v':[], 'a':[], 'd':[]}
	#sverbs = 'is are was were be do make work play build carry get jump hit hangs watch bless curse put get hide succumb abandon'
	#verbs = sverbs.split(' ')
	#wclasses['v'] = verbs
	wclasses = {'a': [], 'n': ['aback', 'abandonment', 'abase', 'abasement', 'abasements', 'abaft', 'abatement', 'abatements', 'abater'], 'd': [], 'v': ['is', 'are', 'was', 'were', 'be', 'do', 'make', 'work', 'play', 'build', 'carry', 'get', 'jump', 'hit', 'hangs', 'watch', 'bless', 'curse', 'put', 'get', 'hide', 'succumb', 'abandon', 'abandoned', 'abandoning', 'abandons', 'abased', 'abases', 'abash', 'abashed', 'abashes', 'abashing', 'abasing', 'abate', 'abated', 'abates']}
	
	for word in words:
		skip = False
		print word, "is a: ",
		for wclass, wlist in wclasses.iteritems():
			if word in wlist:
				print wclass
				skip = True
			#end if
		#next wclass, wlist
		if skip:
			continue
		#end if
		wclass = stdin.readline().replace("\n", '')
		#wclass = wclass[1]
		if wclass == 'x' or wclass == 'q':
			break
		elif wclass in wclasses:
			wclasses[wclass].append(word)
		else:
			print "Word unclassed."
		#end if
	#next word
	print wclasses

#end def classify_words()

classify_words()

