#!/usr/bin/env python

# tstega1.py
# Text Steganography
# by Javantea
# Sept 29, 2006 (on the plane to toorcon)

from sys import stdin

from random import choice, randint

def gen_char_word():
	
	# Parse the words file.
	swords = open('words', 'r').read()
	words = swords.split("\n")
	print "Dictionary Length:", len(words)
	# 38620
	i = 0
	char_word = {}
	for c in range(ord('a'), ord('z') + 1):
		print chr(c), 
		# Get all the words that start with n in an array.
		e = []
		while (i < len(words)) and (words[i] != '') and (words[i][0] == chr(c)):
			e.append(words[i])
			i += 1
		#loop
		# Add the array to d.
		char_word[chr(c)] = e
		print len(e)
	#next c
	
	# char_word now contains {c : [words that start with c], 
	#	d : [words that start with d]}
	
	"""
	It should be quite obvious that we would be foolish to actually use such an 
	idiotic key when actually trying to steg the data. But for now, we are trying 
	to show off our sneakiness.
	It is important that we are not satisfied with bad looking stuff unless 
	we actually are trying for bad looking stuff. I would guess that as 
	spam gets better we will want to use a random permutation of nvna:
	John made birds happy.
	"""
	return char_word
#end def gen_char_word()

def encrypt(secret, skey, char_word):
	# the key is an array of ints that decides the spacing between each real char.
	key = []
	for c in skey:
		key.append(ord(c))
	#next c
	
	output = ''
	# in = a
	# out = when I was young and
	pos = 0
	for c in secret:
		outpos = 0
		while outpos < key[pos % len(key)]:
			# Print a random word.
			output += choice(char_word[chr(randint(97, 122))]) + ' '
			outpos += 1
		#loop
		output += choice(char_word[c]) + ' '
		pos += 1
	#next c
	# The last one is always the attack one.
	# We add a random number of junk at the end.
	for i in range(randint(1,key[pos % len(key)])):
		output += choice(char_word[chr(randint(97, 122))]) + ' '
	#next i
	return output
#end def encrypt(secret, skey, char_word)

def decrypt(ciphertext, skey, char_word):
	key = []
	for c in skey:
		key.append(ord(c))
	#next c
	
	output = ''
	
	outpos = 0
	pos = 0
	cwords = ciphertext.split(" ")
	for cword in cwords:
		if pos < key[outpos % len(key)]:
			pos += 1
			continue
		#end if
		pos = 0
		outpos += 1
		for c,a in char_word.iteritems():
			if cword in a:
				output += c
				break
			#end if
		#next c,a
	#next cword
	return output
#end def decrypt(ciphertext, skey, char_word)

def main():
	from getpass import getpass
	from base64 import b16decode
	char_word = gen_char_word()
	# Input the secret and the key from the stdin.
	print "Secret: ",
	secret = stdin.readline().replace("\n", "").lower()
	#print "Key: ",
	b16key = getpass("Key(hex): ")
	# FIXME: silent fixing of idiots with bad hex keys.
	if len(b16key) % 2:
		b16key += '0'
		print "Your key required a zero to be even length, so I added it."
	#end if
	for k in b16key:
		if k not in '0123456789abcdef':
			print "Error: Bad key. needs to be hex:", k
			return 1
		#end if
	#next k
	skey = b16decode(b16key) # stdin.readline().replace("\n", "")
	
	ciphertext = encrypt(secret, skey, char_word)
	print "Ciphertext:"
	print ciphertext
	print "Decrypted:"
	print decrypt(ciphertext, skey, char_word)
	return 0
#end def main()

if __name__ == '__main__':
	main()
#end if
